/*
 * stateflow.h
 *
 *  Created on: Apr 8, 2015
 *      Author: Jordan
 */

#ifndef USER_CODE_STATEFLOW_H_
#define USER_CODE_STATEFLOW_H_

#define DISPLAY_PID 1

typedef enum {
	AUTOPILOT_DISARMED,
	AUTOPILOT_ARMED,
	AUTOPILOT_TUNING,
} autopilot_state_t;

#define CMD_THRESHOLD 0.1

typedef enum {
	STICK_DONT_CARE,
	STICK_LOW,
	STICK_MID,
	STICK_HIGH,
} stick_pos_t;

typedef struct {
	stick_pos_t ail, ele, rud, thr, aux1, aux2;
} stick_cmd_t;

typedef enum {
	FLIGHT_MODE_RATE,
	FLIGHT_MODE_ANGLE,
	FLIGHT_MODE_VELOCITY,
	FLIGHT_MODE_WAYPOINT,
} flight_mode_t;

autopilot_state_t get_autopilot_state();
void update_state();
uint8 check_stick_cmd(stick_cmd_t* stick_cmd, float32* stick_array);
flight_mode_t get_flight_mode();

#endif /* USER_CODE_STATEFLOW_H_ */
